
**************************************************************************************************************************************************
******************* Code for 'Doing Less with Less: Capital Misallocation, investment and the prodcutivty slowdown in Australia *******************
***************************************************** Code for regressions ******************************************************************

**************************************************DATE: AUG 2022 ******************************************************************************
**************************************************** AUTHOR: Jonathan Hambur *******************************************************************
*********************************************************************************************************************************************



*** Code strcuture
*01. REgressions of i_y over time
*02 REallocation regressions


clear
use save "$outputs\reg_file.dta", replace
********* 01 REgressions of i_y over time

**Figure 2

eststo  clear
	eststo: reg i_y i.fyear if division!="B"
	eststo: areg i_y i.fyear i.size i.young  if division!="B", a(industry)
	eststo: xtreg i_y i.fyear i.size i.young  if division!="B", fe
	esttab using "$regs\figure_2.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace
	eststo  clear
	
**Figure 3

	eststo clear
	eststo: areg i_y i.fyear i.size i.young  if division!="B" & fyear>2005, a(industry)
	eststo: areg i_y i.fyear i.size i.young  if division!="B" & q_dev_prod_MFP==1 & fyear>2005, a(industry)
	eststo: areg i_y i.fyear i.size i.young  if division!="B" & q_dev_prod_MFP==2 & fyear>2005, a(industry)
	eststo: areg i_y i.fyear i.size i.young  if division!="B" & q_dev_prod_MFP==3 & fyear>2005, a(industry)
	eststo: areg i_y i.fyear i.size i.young  if division!="B" & q_dev_prod_MFP==4 & fyear>2005, a(industry)
	esttab using "$regs\figure_3.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace mtitle("total" "prod_1" "prod_2" "prod_3" "prod_4" )
	eststo  clear
		

**Figure 5
	eststo clear
	****** firm level inv grow by quartile
	eststo: areg i_y i.fyear i.size i.young  if division!="B" & fyear>2005, a(industry)
	eststo: areg i_y i.fyear i.size i.young  if division!="B" & mu_change_q==1 & fyear>2005, a(industry)
	eststo: areg i_y i.fyear i.size i.young  if division!="B" & mu_change_q==2 & fyear>2005, a(industry)
	eststo: areg i_y i.fyear i.size i.young  if division!="B" & mu_change_q==3 & fyear>2005, a(industry)
	eststo: areg i_y i.fyear i.size i.young  if division!="B" & mu_change_q==4 & fyear>2005, a(industry)
	esttab using "$regs\figure_5.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace mtitle("total"  "mu_1" "mu_2" "mu_3" "mu_4")
	eststo  clear
	

********* 02 REallocation regressions
	
** Table 1	 Baseline regression for different metrics

eststo: areg d_k_bound c.l.dev_prod_MFP c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear  i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP  < dev_prod_MFP99 & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99  & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg dfte c.l.dev_prod_MFP##i.period1  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99  & fyear>2005, a(ind_yr) vce(cluster industry)

esttab using "$regs\Table1.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace	mtitle("NCA no change" "NCA change"  "FTE")
	eststo clear
	
	
	
	** Figure 4
			local rvar d_k_bound
	
	eststo clear

	eststo: areg d_k_bound i.l.q_dev_prod_MFP##i.period1  i.l.q_dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99 & fyear>2005, a(ind_yr) vce(cluster industry)
	
	esttab using "$regs\Figure_4.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace	
	eststo clear	
	
	
	** Table 3
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99 & intense ==4 & intense !=. & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99 & intense !=4 & intense !=. & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99 & q_intan_s ==4 & intense !=. & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99 & q_intan_s !=4 & intense !=. & fyear>2005, a(ind_yr) vce(cluster industry)
		esttab using "$regs\Table_3.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace mtitle("Digital intense" "Not digital intense" "Intang intense" "Not ntang intense")	
	eststo clear
	
	** Table 4
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1 c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99 & l2.gear_50==0 & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1 c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99 & l2.gear_50==1 & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99 & l.cf_p ==1 & fyear>2005, a(ind_yr) vce(cluster industry)
	eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1 c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99  & l.cf_p ==0 & fyear>2005, a(ind_yr) vce(cluster industry)	
		
		esttab using "$regs\Table_4.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace mtitle("High gear" "Low gear" "CF pos" "CF neg")
		eststo clear
	
** Table 5		
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1 c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear  i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP  < dev_prod_MFP99 & q_FINDEPRZ==4 & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1 c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear  i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP  < dev_prod_MFP99 & q_FINDEPRZ!=4 & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1 c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear  i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP  < dev_prod_MFP99 & q_QUITYFINDEP==4 & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1 c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear  i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP  < dev_prod_MFP99 & q_QUITYFINDEP!=4 & fyear>2005, a(ind_yr) vce(cluster industry)
		esttab using "$regs\Table_5.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace mtitle("Fin intense" "Not fin intense" "Equity intense" "Not equity intense")	
		eststo clear
	
		
** Table 6		
eststo: areg dfte c.l.dev_prod_MFP##i.period1 c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear  i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP  < dev_prod_MFP99 & q_FINDEPRZ==4 & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg dfte c.l.dev_prod_MFP##i.period1 c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear  i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP  < dev_prod_MFP99 & q_FINDEPRZ!=4 & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg dfte c.l.dev_prod_MFP##i.period1 c.l.dev_prod_lva##c.demean_unemp_state i.State##i.fyear  i.size dlgo i.young if l.dev_prod_lva>dev_prod_lva1 & l.dev_prod_lva  < dev_prod_lva99 & q_FINDEPRZ==4 & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg dfte c.l.dev_prod_MFP##i.period1 c.l.dev_prod_lva##c.demean_unemp_state i.State##i.fyear  i.size dlgo i.young if l.dev_prod_lva>dev_prod_lva1 & l.dev_prod_lva  < dev_prod_lva99 & q_FINDEPRZ!=4 & fyear>2005, a(ind_yr) vce(cluster industry)
		esttab using "$regs\Table_5.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace mtitle("Fin intense" "Not fin intense" "Equity intense" "Not equity intense")	
		eststo clear
			
		
** Table 7


eststo: areg d_k_bound c.l.dev_prod_MFP c.l.dev_prod_MFP#c.l.demean_mi_$reg    c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99 & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg i_k c.l.dev_prod_MFP c.l.dev_prod_MFP#c.l.demean_mi_$reg    c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99 & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg dfte c.l.dev_prod_MFP c.l.dev_prod_MFP#c.l.demean_mi_$reg    c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99 & fyear>2005, a(ind_yr) vce(cluster industry)
	esttab using "$regs\Table_7.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace mtitle("Capial grow" "gross inv" "FTE grow")	
			eststo clear
		
	
** Table B3



eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99  & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg d_rk_pim1_bound c.l.dev_prod_MFP##i.period1  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99  & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg i_k c.l.dev_prod_MFP##i.period1  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99  & fyear>2005, a(ind_yr) vce(cluster industry)

esttab using "$regs\Table_B3.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace	mtitle("Capial grow" "PIM capital grow" "gross inv" ")	
	eststo clear
	
	
** Table B4

eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99  & fyear>2005 & div!="A" & div!="B", a(ind_yr) vce(cluster industry)
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99  & fyear>2005& div!="A" & div!="B" & q_FINDEPRZ==4, a(ind_yr) vce(cluster industry)
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99  & fyear>200 & div!="A" & div!="B" & q_FINDEPRZ!=4, a(ind_yr) vce(cluster industry)

esttab using "$regs\Table_B$.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace	mtitle("All" "fin dep" "not find dep")	
	eststo clear
	
	
	
** Table B5
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99  & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young c.l.d_k_bound##i.period1 if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99  & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young c.l.k##i.period1 if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99  & fyear>2005, a(ind_yr) vce(cluster industry)
esttab using "$regs\Table_B5.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace	mtitle("Base" "Lag K growth" "Lag K stock")	
	eststo clear
	
	** Table B6
eststo: reg dev_prod_MFP l.c.dev_prod_MFP if period1 == 1, robust		
eststo: reg dev_prod_MFP l.c.dev_prod_MFP if period1 == 2, robust	
eststo: reg dev_prod_MFP l.c.dev_prod_MFP if period1 == 3, robust	
esttab using "$regs\Table_B6.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace mtitle("Pre-GFC" "GFC" "Post-GFC")	
eststo  clear	
	
		** Table B7
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99  & fyear>2005 , a(ind_yr) vce(cluster industry)
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99  & fyear>2005 & Y_nom>2, a(ind_yr) vce(cluster industry)
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size##i.period1 c.dlgo##i.period1 i.young##i.period1 if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99  & fyear>2005, a(ind_yr) vce(cluster industry)
esttab using "$regs\Table_B7.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace mtitle("Base" "No belw $2m" "Controls vary")	
	eststo  clear	
	
** Table B8 - Table 1 replacing the markup measure	


	
		
** Table B9 - cap prod, by age small sample
					local rvar d_k_bound
		
		eststo: areg `rvar' c.l.dev_prod_kva##i.period1  c.l.dev_prod_kva##c.demean_unemp_state i.State##i.fyear i.size dlgo if l.dev_prod_kva>dev_prod_kva1 & l.dev_prod_kva < dev_prod_kva99 & young ==1 & fyear>2005, a(ind_yr) vce(cluster industry)
	
		eststo: areg `rvar' c.l.dev_prod_kva##i.period1  c.l.dev_prod_kva##c.demean_unemp_state i.State##i.fyear i.size dlgo if l.dev_prod_kva>dev_prod_kva1 & l.dev_prod_kva < dev_prod_kva99 & young ==0 & fyear>2005, a(ind_yr) vce(cluster industry)


	esttab using "$regs\Table_B9.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace mtitle("Young" "Old")	
	eststo clear
	
		
		
** Table 	B10
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1 c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear  i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP  < dev_prod_MFP99 & q_FINDEPRD==4 & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1 c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear  i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP  < dev_prod_MFP99 & q_FINDEPRD!=4 & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1 c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear  i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP  < dev_prod_MFP99 & q_FINDEPINTAN==4 & fyear>2005, a(ind_yr) vce(cluster industry)
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1 c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear  i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP  < dev_prod_MFP99 & q_FINDEPINTAN!=4 & fyear>2005, a(ind_yr) vce(cluster industry)
		esttab using "$regs\Table_B10.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace mtitle("Fin intense RD" "Not fin intense RD" "Fin intense intan" "Not fin intense intan")	
			eststo clear


	
** Table 	B11 by division
levelsof division, local(divs)

foreach div in `divs' {
eststo: areg d_k_bound c.l.dev_prod_MFP##i.period1  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99  & fyear>2005 & divsion==`div', a(ind_yr) vce(cluster industry)
}
	esttab using "$regs\Table_B11.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace
	eststo clear
	
	
	